package gov.va.genisis2.converter;

import static org.junit.Assert.*;

import java.util.HashSet;
import java.util.Set;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dto.UserRoleTypeDTO;
import gov.va.genisis2.model.RoleType;
import gov.va.genisis2.model.User;
import gov.va.genisis2.model.UserRoleType;
import gov.va.genisis2.model.UserType;
import gov.va.genisis2.util.Helper;

/**
 * @author Getaneh Kassahun
 * 
 * 
 */
public class UserRoleTypeConverterTest extends AbstractMockMvcTests {

	/** The userRoleTypeConverter. */
	private UserRoleTypeConverter userRoleTypeConverter;

	/** The userRoleTypeDTO. */
	private UserRoleTypeDTO userRoleTypeDTO;

	/** Run before all test methods. */
	@Before
	public void setUp() {
		userRoleTypeConverter = new UserRoleTypeConverter();
		userRoleTypeConverter.setRoleTypeConverter(getMockRoleTypeConverter());
		userRoleTypeConverter.setUserTypeConverter(getMockUserTypeConverter());
	}

	/** To test Convert method */
	@Test
	public void testConvert() {
		UserRoleType userRoleType = Helper.getUserRoleType();
		userRoleType.setRoleType(Helper.getNewRoleType());
		userRoleType.setUserType(Helper.getNewUserType());

		userRoleTypeDTO = userRoleTypeConverter.convert(userRoleType);
		assertEquals(1, userRoleTypeDTO.getId());
	}

	/** To testConvert_Null */
	@Test
	public void testConvert_Null() {
		userRoleTypeDTO = userRoleTypeConverter.convert(new UserRoleType());
		assertEquals(0, userRoleTypeDTO.getId());
	}

	@Test
	public void testConvertUserRoleTypesNull() {
		userRoleTypeConverter.convertUserRoleTypes(new HashSet<>(0));
	}

	/** To test convertUserRoleTypes */
	@Test
	public void testConvertUserRoleTypes() {
		Set<UserRoleType> userRoleTypeList = new HashSet<>(0);
		userRoleTypeList.add(Helper.getUserRoleType());
		Set<UserRoleTypeDTO> userRoleTypeDTOList = userRoleTypeConverter.convertUserRoleTypes(userRoleTypeList);
		assertEquals(1, userRoleTypeDTOList.size());
	}
	
	/** To test Populate */
	@Test
	public void  testPopulate() {
		//UserRoleType userRoleType, User user, UserType userType, RoleType roleType
		UserRoleType userRoleType = new UserRoleType();
		assertNotNull(userRoleTypeConverter.populate(userRoleType, Helper.getNewUser(), Helper.getNewUserType(), Helper.getNewRoleType()));
		userRoleType.setId(1);
		assertNotNull(userRoleTypeConverter.populate(userRoleType, Helper.getNewUser(), Helper.getNewUserType(), Helper.getNewRoleType()));
		
	}
}
